// ToolForm.h
//
// This file declares a Form-derived window that is the
// user interface for the simple Tool plug-in that this
// project creates. The Form contains two buttons. One button
// disables all LA modules in the system. The other enables
// all LA modules.
/////////////////////////////////////////////////////////////

#pragma once

namespace CPPSamplePlugIn
{

    // ToolForm class
    //
    // This class implements the user interface for the Tool plug-in.
    // Instances of CPPToolPlugIn create ToolForm objects. The ToolForm
    // recieves a reference to the TPI.NET ITlaPlugInSupport object
    // in its constructor. 
    //
    // To ensure the best interaction with the TLA user interface,
    // this class is derived from TlaForm.
    __gc class ToolForm : public Tektronix::LogicAnalyzer::TpiNet::TlaForm
    {
		System::ComponentModel::Container* m_components;
        
        // Places controls on the Form surface
        void InitializeComponent();
        
		// Variables for the two Buttons that appear on the form.
		System::Windows::Forms::Button* m_enableLAsButton;
		System::Windows::Forms::Button* m_disableLAsButton;
        
		// The ToolForm caches a reference to the ITlaPlugInSupport object.
		Tektronix::LogicAnalyzer::TpiNet::ITlaPlugInSupport* m_plugInSupport;

		// Handler method for click events on the m_disableLAsButton.
		void DisableLAsButton_Click
			(System::Object* sender, System::EventArgs* e);

		// Handler method for click events on the m_enableLAsButton.
		void EnableLAsButton_Click
			(System::Object* sender, System::EventArgs* e);
		
		// Utility method that mass-enables or mass-disables 
		// all LA modules in the system.
		void SetLAsEnabledState (bool enabledState);


    public:
		void Dispose( bool disposing );
        ToolForm(Tektronix::LogicAnalyzer::TpiNet::ITlaPlugInSupport* support);
    };
}